<?php

defined('SYSPATH') or die('No direct script access.');

class Profile_Controller extends Protected_Pages_Template_Controller {

  public function __construct() {
    parent::__construct();

        $this->template->title = "Dashboard";
              $this->template->styles .= html::stylesheet("styles/bootstrap.css");
        $this->template->styles .= html::stylesheet("styles/spectrumtalent.css");
        $this->template->styles .= html::stylesheet("styles/fontawesome-free/css/all.min.css");
        $this->template->styles .= html::stylesheet("styles/slick.css");
        $this->template->styles .= html::stylesheet("styles/dashboard/style.css");
        $this->template->styles .= html::stylesheet("styles/toastr.min.css");
        $this->template->scripts = html::script("scripts/jquery-3.3.1.slim.min.js");
        $this->template->scripts .= html::script("scripts/jquery-1.9.1.js");
         $this->template->scripts .= html::script("scripts/slick.js");
        $this->template->scripts .= html::script("scripts/bootstrap.min.js");
        $this->template->scripts .= html::script("scripts/popper.min.js");
        $this->template->scripts .= html::script("scripts/toastr.min.js");
        $this->template->scripts .= html::script("scripts/pnlProfile.js");
                $this->template->scripts .= html::script("scripts/util.js");

  }

  public function index() {
    $this->template->title = "Profile";
    $this->template->body->title = "";

    if(!Session::instance()->get("user_id")){
      url::redirect('/login');
    }
    $user = Doctrine::getTable("TblUsers")->find(Session::instance()->get("user_id"));
    $params = array(
      "user" => $user
    );
    
    $this->template->body->content = View::factory("admin/content_profile", $params)->render();
  }

public function save(){
  $this->auto_render = false;
  $post = $_POST;

    $user = Doctrine::getTable("TblUsers")->findOneById(Session::instance()->get("user_id"));
    $user->firstname = $post["firstname"];
    $user->lastname = $post["lastname"];
    $user->email = $post["email"];
    if($user->password != $post["password"]){
      $user->password = Auth::instance()->hash($post["password"]);
    }
    $user->username = $post["username"];
    $user->save();
  
}

  public function get_table_list(){
    $this->auto_render = false;

    $tables = TblTables::get_tables();
    $params = array(
      "tables" => $tables,
      "table_options" => util::get_table_options_dropdown()
    );

    $to_display = view::factory("content_table_list", $params)
        ->render();

    echo json_encode(array(
      "tables" => $to_display
    ));

  }

  public function bill_out($table_id){
    $this->auto_render = false;

    TblOrders::archive_data($table_id);
    TblOrders::save_to_sales($table_id);
    TblOrders::flush_records($table_id);
    TblTables::delete_table_from_list($table_id);

    return 0;
  }

  public function transfer_table($transfer_to){
    $this->auto_render = false;
    $post = $_POST;
    $table_option = Doctrine::getTable("TblTableOptions")->find($transfer_to);
   
    if($post["custom_name"] == ""){
      $table_name = $table_option->name;
       $table_option_id = $table_option->id;
  }else{
      $table_name = $post['custom_name'];
      $table_option_id = 0;
  }
    $table = Doctrine::getTable("TblTables")->findOneByName($post['name']);
    $table->name = $table_name;
    $table->table_option_id = $table_option;
    $table->transferred_from = $post['name'];
    $table->save();

  }
public function delete_table(){
    $this->auto_render = false;
 
    $post = $_POST;
    $auth = Auth::instance()->hash($post["pin"]);
  
    $user = Doctrine::getTable("TblUsers")->findOneByPassword($auth);

    if($user && $user->role_id <= 2){
        $table = Doctrine::getTable("TblTables")->find($post["tbl_id"]);
        $table->delete();
        
        echo 0;
      }else{
       echo "denied";
      }
  }


}
