<?php defined('SYSPATH') OR die('No direct access allowed.'); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html lang="en" xmlns="http://www.w3.org/1999/xhtml">
<!--Head-->
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
<meta name="description" content=""/>

<link href="https://vjs.zencdn.net/7.8.4/video-js.css" rel="stylesheet" />

  <!-- If you'd like to support IE8 (for Video.js versions prior to v7) -->
  <script src="https://vjs.zencdn.net/ie8/1.1.2/videojs-ie8.min.js"></script>

<link rel="stylesheet" href="<?=url::base()?>styles/spectrumtalent.css" integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">
<title><?=$title?></title>
<!-- Bootstrap CSS -->


<!--Styles-->
<?=$styles?>
<!--End Styles-->

<!--Scripts-->
<?=isset($scripts) ? $scripts : ""?>
<?=view::factory("panel_script_content")?>
<!--End Scripts-->
</head>
<!--End Head-->
<body id="content">
<div class="home-top">
  <nav class="navbar navbar-light navbar-expand-md">
    <a class="navbar-brand" href="<?=url::base()?>panel/home"><span class="logo">Spectrum Talent</span></a>
    <button class="navbar-toggler ml-1" type="button" data-toggle="collapse" data-target="#collapsingNavbar2">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="navbar-collapse collapse justify-content-between align-items-center w-100" id="collapsingNavbar2">
        <ul class="navbar-nav mx-auto">
            <li class="nav-item dropdown">
                <a class="nav-link" href="<?=url::base()?>">Home</a>
            </li>
                <?$states = TblStates::get_states();?>
                 <?foreach($states as $state):?>
                 
            <li class="nav-item dropdown">
                <?if($state->id != 4):?>
                <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown"><?=$state->name?></a>
                <ul class="dropdown-menu">
                     <?$talents = TblTalents::get_talents_by_state($state->name);?>
                      <?foreach($talents as $talent):?>
                    <a href="<?=url::base()?>panel/talents/lists/<?=$state->id?>/<?=$talent->category_id?>" class="dropdown-item"><?=$talent->category_name;?></a>
                    <?endforeach?>
                </ul>
                    <?else:?>
                    <a class="nav-link" target="_blank" href="http://envymanagement.com"><?=$state->name?></a>
                    <?endif?>
            </li>
            <?endforeach?>
        </ul>
        <ul class="nav navbar-nav flex-row justify-content-center flex-nowrap right-btn">
            <li class="nav-item"><a class="nav-link" href="<?=url::base()?>panel/about">About</a> </li>
            <li class="nav-item"><a class="nav-link btn btn-outline-dark br-50" href="<?=url::base()?>panel/contact">Contact</a> </li>
        </ul>
    </div>
</nav>
	
</div>
<?=$body?>
   


<script type="text/javascript">
    /*
    Carousel
*/
$('#myCarousel').carousel({
  interval: 10000
})

$('.carousel .carousel-item').each(function(){
    var minPerSlide = 3;
    var next = $(this).next();
    if (!next.length) {
    next = $(this).siblings(':first');
    }
    next.children(':first-child').clone().appendTo($(this));
    
    for (var i=0;i<minPerSlide;i++) {
        next=next.next();
        if (!next.length) {
          next = $(this).siblings(':first');
        }
        
        next.children(':first-child').clone().appendTo($(this));
      }
});

$(document).ready(function(){
    $('.home-slider').slick({
        slidesToShow: 8,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 2500,
        arrows: true,
        dots: false,
        pauseOnHover: false,
        responsive: [{
            breakpoint: 768,
            settings: {
                slidesToShow: 3
            }
        }, {
            breakpoint: 520,
            settings: {
                slidesToShow: 1            }
        }]
    });
});
$(document).ready(function(){
        $('.home-slider').slick({
            autoplay:true,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class='fa fa-angle-right' aria-hidden='true'></i></button>"
        });
    });

$(document).ready(function(){
    $('.customer-logos').slick({
        slidesToShow: 8,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 2500,
        arrows: false,
        dots: false,
        pauseOnHover: false,
        responsive: [{
            breakpoint: 768,
            settings: {
                slidesToShow: 4
            }
        }, {
            breakpoint: 520,
            settings: {
                slidesToShow: 3
            }
        }]
    });
});
</script>
</body>
</html>


