$(document).ready(function(){
  pnlStates.init();
});

pnlStates = {
   init : function(){
    pnlStates.save();
    pnlStates.listStates();
    pnlStates.deleteState();
  },
 save: function (noteDOM) {
        $("form#frmStates").submit(function (e) {
            e.preventDefault();
            var formData = new FormData($(this)[0]);
                $.ajax({
                    type: "post",
                    url: util.url("admin/states/save"),
                    data: formData,
                    success: function (data) {
                      if(data == "Error"){
                          toastr.error("State Exists", "Error!");
                      }else{
                        toastr.success("State added", "Success!");
                        pnlStates.listStates();
                      }
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
    
        });

    },

listStates: function(){
  $.ajax({
      type    : 'GET',
      url     :  util.url("admin/states/get_list"),
      success : function(data){
        $('#states_list').html(data);
      }
    });
},

deleteState: function(){
   $(document).on('click','#delete_state',function (e) {
     e.preventDefault();
     var r = confirm("Are you sure you want to delete this state?");
            if (r == true) {
                $.ajax({
                    type: "get",
                    url: util.url('admin/state/delete_state/') + $(this).attr('data-id'),
                    success: function (data) {
                       toastr.success("State deleted.", "Successful!");

                       pnlStates.listStates();
                    }
                });//end of ajax 
            } 
        });

  },
};
